#include <bits/stdc++.h>

#define ull long long

using namespace std;

struct Point {
    ull x, y;

    Point(ull x=0, ull y=0) : x(x), y(y) {}
    bool operator<(const Point& p) const {
        return x<p.x || (x==p.x && y<p.y);
    }
    bool operator!=(const Point& p) const {
        return x!=p.x || y!=p.y;
    }
    static ull cross(const Point& o, const Point& a, const Point& b) {
        return (a.x-o.x)*(b.y-o.y) - (a.y-o.y)*(b.x-o.x);
    }
};

vector<Point> convexHull(vector<Point>& points) {
    vector<Point> lower, upper;
    for (int i=0; i<points.size(); i++) {
        while (lower.size()>=2 && Point::cross(lower[lower.size()-2], lower.back(), points[i]) <= 0)
            lower.pop_back();
        lower.push_back(points[i]);
    }
    for (int i=points.size()-1; i>=0; i--) {
        while (upper.size()>=2 && Point::cross(upper[upper.size()-2], upper.back(), points[i]) <= 0)
            upper.pop_back();
        upper.push_back(points[i]);
    }
    lower.pop_back();
    upper.pop_back();
    lower.insert(lower.end(), upper.begin(), upper.end());
    return lower;
}

ull polygonArea(const vector<Point>& polygon) {
    int n=polygon.size();
    ull area=0;
    for (int i=0; i<n; i++) {
        int j = (i+1)%n;
        area += polygon[i].x * polygon[j].y;
        area -= polygon[i].y * polygon[j].x;
    }
    return abs(area)/2;
}

int main() {
    int n;
    cin>>n;
    vector<Point> points(n);
    for (int i=0; i<n; i++) {
        cin>>points[i].x>>points[i].y;
    }
    sort(points.begin(), points.end());

    vector<Point> hull = convexHull(points);
    ull area = polygonArea(hull);
    Point outcast;

    if (hull.size() == 3) {
        ull minArea = area;
        for (int j=0; j<3; j++) {
            Point outcast = hull[j];
            vector<Point> newPoints;
            for (int i=0; i<n; i++) {
                if (outcast != points[i]) {
                    newPoints.push_back(points[i]);
                }
            }
            minArea = min(minArea, polygonArea(convexHull(newPoints)));
        }
        cout<<minArea;
        return 0;
    }

    ull triangleArea = 0;
    for (int i=0; i<hull.size(); i++) {
        vector<Point> triangle;
        if (i==0) {
            triangle.push_back(hull[hull.size()-1]);
        } else {
            triangle.push_back(hull[i-1]);
        }
        triangle.push_back(hull[i]);
        triangle.push_back(hull[(i+1) % hull.size()]);
        ull currentArea = polygonArea(triangle);
        if (currentArea > triangleArea) {
            outcast = hull[i];
            triangleArea = currentArea;
        }
    }

    vector<Point> newPoints;
    for (int i=0; i<n; i++) {
        if (outcast != points[i]) {
            newPoints.push_back(points[i]);
        }
    }
    cout<<polygonArea(convexHull(newPoints));
    return 0;
}